
## Shift to Off-Box Programming

- APIs have enabled a shift from on-box to off-box programmability for Cisco devices.
- Most Cisco platforms now support APIs for off-box network automation and management.
- APIs are becoming more standardized and open across the Cisco portfolio.

---

## Cisco Platforms and Supported APIs

|Cisco Platform|Programmatic APIs|
|---|---|
|Cisco IOS XE|NETCONF, RESTCONF|
|Cisco IOS XR|NETCONF, RESTCONF, gRPC|
|Cisco NX-OS|NX-API CLI, NX-API REST, NETCONF|
|Cisco Secure Firewall ASA|REST|
|Cisco APIC|REST|
|Cisco Catalyst Center|REST|
|Cisco Catalyst SD-WAN Manager|REST|
|Cisco Identity Services Engine (ISE)|REST|
|Cisco Secure Firewall Mgmt Center|REST|

---

## API Usage Examples

### NETCONF/RESTCONF

- Used by: Cisco IOS XE (Catalyst 8000, ASR 1000, Catalyst 9000)
- Enables: Structured, programmable configuration and management.

### NETCONF, RESTCONF, gRPC

- Used by: Cisco IOS XR (ASR 9000)
- Enables: Advanced programmability and streaming telemetry.

### NX-API (CLI/REST)

- Used by: Cisco Nexus 9000 Series
- Enables: Programmatic access to CLI and REST interfaces.

### REST APIs

- Used by: Cisco APIC, Catalyst Center, Catalyst SD-WAN Manager, Secure Firewall ASA, ISE, Secure Firewall Management Center
- Enables: RESTful management and automation of network services and security.

---

# Cisco Secure Firewall Management Center REST API

## Overview

- Provides a lightweight REST API for management.
- Can be accessed via any REST client (browser plugins or standalone clients).
- Supports standard HTTP methods for interacting with resources.

## Key Features

- Access to configuration and operational data.
- Token-based authentication (tokens valid for 30 minutes, renewable up to 3 times).
- Permissions are managed via Secure Firewall Management Center user roles.
- Supports query parameters for filtering, pagination, and output control.

## API Explorer

- Built-in web tool for browsing and testing available REST API endpoints.
- URL format:  
    `https://<management_center_IP_or_name>:<https_port>/api/api-explorer`
- Supports OpenAPI Specification (OAS) for endpoint documentation and sample code generation (CodeGen utility).

## Authentication Process

- Obtain a token by POST to:  
    `https://<management_center_IP_or_name>:<https_port>/api/fmc_platform/v1/auth/generatetoken`
- Use the access token in HTTP headers for subsequent API requests.
- Note: Separate user accounts for API and GUI are recommended.

## Example Request Structure

- HTTPS request format:  
    `https://<management_center_IP_or_name>:<https_port>/<object_URL>/<object_UUID>options`
    - `<management_center_IP_or_name>`: IP address or FQDN
    - `<https_port>`: Typically 443 (often omitted)
    - `<object_URL>`: Specific endpoint for the resource
    - `{UUID}`: Resource identifier

## Supported HTTP Methods

- **GET:** Retrieve data
- **POST:** Create new object (with JSON payload)
- **PUT:** Update existing object
- **DELETE:** Remove object
- **PATCH:** Not supported

## Query Parameters

- Control results (e.g., expanded, offset, limit).
- Filter by model attributes.

---

# Cisco Secure Firewall Management Center REST API Example

## Retrieve System Information

- **Request Type:** GET
- **Description:** Retrieve server version info
- **URL:**  
    `https://<management_center_IP_or_name>/api/fmc_platform/v1/info/serverversion`
- **Permissions:** Required for access

### Sample JSON Response:

json


```json
{
  "links": {...},
  "items": [
    {
      "serverVersion": "7.2.4 (build 169)",
      "geoVersion": "...",
      "hostname": "fmc",
      "model": "Secure Firewall Management Center for VMware",
      ...
    }
  ],
  "paging": {...}
}
```

- Similar API calls can retrieve audit logs, manage device groups, policies, and other objects.

